/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// eye trilogy 3:eye of sun
#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
// varying vec2 surfacePosition;


#define MAX_ITER 32
vec3 sunsetGrad( const float x ) {
	float r = x*2.-.1; 
	float g = 1.-(1.-x)*2.; 
	float b = sin( (min(x,.5)*3.-.33) * 3.1415926);
	return( vec3( r, g,b ) );
}
void main( void ) {

	vec2 p = surfacePosition*12.0;
	vec2 i = p;
	float c = 9.0;
	float inten = 1.0;

	for (int n = 0; n < MAX_ITER; n++) {
		float t = time * (1.0 - (1.0 / float(n+1)))+sin(length(p))/length(p);
		i = p + vec2(
			cos(t - i.x) + sin(t + i.y), 
			sin(t - i.y) + cos(t + i.x)
		);
		c += 1.0/length(vec2(
			p.x / (sin(i.x+t)/inten),
			p.y / (cos(i.y+t)/inten)
			)
		);
	}
	c /= float(MAX_ITER);
	
	//gl_FragColor = vec4(vec3(pow(c,1.5))*vec3(0.95, 0.97, 1.8), 1.0);
	gl_FragColor = vec4( sunsetGrad( pow(c+0.5,1.5) ), 1.0 );
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}